VERSION 5.00
Begin VB.Form frmAutotune 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "2510-AT Autotune Start"
   ClientHeight    =   7440
   ClientLeft      =   45
   ClientTop       =   630
   ClientWidth     =   8535
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   7440
   ScaleWidth      =   8535
   StartUpPosition =   2  'CenterScreen
   Begin VB.CommandButton cmdPIDStep 
      Caption         =   "PID Temperature Control"
      Height          =   735
      Left            =   6960
      TabIndex        =   30
      Top             =   3840
      Width           =   1455
   End
   Begin VB.CommandButton cmdReadStdRegister 
      Caption         =   "Read Std Event Reg"
      Height          =   615
      Left            =   5400
      TabIndex        =   28
      Top             =   5880
      Visible         =   0   'False
      Width           =   975
   End
   Begin VB.Frame fraResults 
      Caption         =   "Autotune Results"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1575
      Left            =   120
      TabIndex        =   15
      Top             =   5760
      Width           =   5055
      Begin VB.TextBox txtMOVKp 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   285
         Left            =   2160
         Locked          =   -1  'True
         TabIndex        =   26
         Top             =   1200
         Width           =   735
      End
      Begin VB.TextBox txtMOVKi 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   285
         Left            =   3120
         Locked          =   -1  'True
         TabIndex        =   25
         Top             =   1200
         Width           =   735
      End
      Begin VB.TextBox txtMOVKd 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   285
         Left            =   4080
         Locked          =   -1  'True
         TabIndex        =   24
         Top             =   1200
         Width           =   740
      End
      Begin VB.TextBox txtMSETKd 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   285
         Left            =   4080
         Locked          =   -1  'True
         TabIndex        =   18
         Top             =   720
         Width           =   740
      End
      Begin VB.TextBox txtMSETKi 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   285
         Left            =   3120
         Locked          =   -1  'True
         TabIndex        =   17
         Top             =   720
         Width           =   735
      End
      Begin VB.TextBox txtMSETKp 
         Appearance      =   0  'Flat
         BorderStyle     =   0  'None
         Height          =   285
         Left            =   2160
         Locked          =   -1  'True
         TabIndex        =   16
         Top             =   720
         Width           =   735
      End
      Begin VB.Label Label6 
         Caption         =   "Minimum Temp Overshoot"
         Height          =   255
         Left            =   240
         TabIndex        =   27
         Top             =   1200
         Width           =   1935
      End
      Begin VB.Label Label5 
         Caption         =   "Coefficients for:"
         Height          =   255
         Left            =   120
         TabIndex        =   23
         Top             =   360
         Width           =   1455
      End
      Begin VB.Label lblD 
         Caption         =   "Kd"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   4320
         TabIndex        =   22
         Top             =   480
         Width           =   255
      End
      Begin VB.Label Label3 
         Caption         =   "Minimum Settle Time"
         Height          =   255
         Left            =   240
         TabIndex        =   21
         Top             =   720
         Width           =   1455
      End
      Begin VB.Label lblI 
         Caption         =   "Ki"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   3360
         TabIndex        =   20
         Top             =   480
         Width           =   255
      End
      Begin VB.Label lblP 
         Caption         =   "Kp"
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   700
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   255
         Left            =   2400
         TabIndex        =   19
         Top             =   480
         Width           =   255
      End
   End
   Begin VB.TextBox txtInstructions 
      Appearance      =   0  'Flat
      BackColor       =   &H80000000&
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   3015
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      TabIndex        =   13
      Text            =   "AutotuneMain03.frx":0000
      Top             =   360
      Width           =   8295
   End
   Begin VB.Frame fraAutoTune 
      Caption         =   "Autotune Settings"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1815
      Left            =   120
      TabIndex        =   3
      Top             =   3720
      Width           =   4455
      Begin VB.Frame fraTuneTempStep 
         Caption         =   "Autotune Temperature Step"
         Height          =   1455
         Left            =   120
         TabIndex        =   8
         Top             =   240
         Width           =   2775
         Begin VB.ComboBox cboStopTemp 
            Height          =   315
            Left            =   1560
            TabIndex        =   2
            Top             =   960
            Width           =   735
         End
         Begin VB.ComboBox cboStartTemp 
            Height          =   315
            Left            =   1560
            TabIndex        =   1
            Top             =   450
            Width           =   735
         End
         Begin VB.Label lblStartTemp 
            Caption         =   "Start Temperature:"
            Height          =   255
            Left            =   120
            TabIndex        =   12
            Top             =   480
            Width           =   1455
         End
         Begin VB.Label lblStopTemp 
            Caption         =   "Final Temperature:"
            Height          =   255
            Left            =   120
            TabIndex        =   11
            Top             =   990
            Width           =   1455
         End
         Begin VB.Label lblC 
            Caption         =   "C"
            Height          =   255
            Index           =   0
            Left            =   2400
            TabIndex        =   10
            Top             =   510
            Width           =   135
         End
         Begin VB.Label lblC 
            Caption         =   "C"
            Height          =   255
            Index           =   1
            Left            =   2400
            TabIndex        =   9
            Top             =   1020
            Width           =   135
         End
      End
      Begin VB.Frame fraSysTau 
         Caption         =   "Tau Value"
         Height          =   1455
         Left            =   3000
         TabIndex        =   4
         Top             =   240
         Width           =   1335
         Begin VB.OptionButton optSysTau 
            Caption         =   "Short"
            Height          =   375
            Index           =   0
            Left            =   240
            TabIndex        =   7
            Top             =   300
            Width           =   975
         End
         Begin VB.OptionButton optSysTau 
            Caption         =   "Medium"
            Height          =   375
            Index           =   1
            Left            =   240
            TabIndex        =   6
            Top             =   650
            Width           =   975
         End
         Begin VB.OptionButton optSysTau 
            Caption         =   "Long"
            Height          =   375
            Index           =   2
            Left            =   240
            TabIndex        =   5
            Top             =   1000
            Width           =   975
         End
      End
   End
   Begin VB.CommandButton cmdAutotune 
      Caption         =   "Begin Autotune"
      Height          =   735
      Left            =   4920
      TabIndex        =   0
      Top             =   3840
      Width           =   1455
   End
   Begin VB.Label lblATStatus 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4920
      TabIndex        =   29
      Top             =   4680
      Width           =   1575
   End
   Begin VB.Image Image3 
      Appearance      =   0  'Flat
      Height          =   585
      Left            =   5700
      Picture         =   "AutotuneMain03.frx":0006
      Stretch         =   -1  'True
      Top             =   6720
      Width           =   2700
   End
   Begin VB.Label lblInstructions 
      Caption         =   "Instructions"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   14
      Top             =   120
      Width           =   2775
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuQuit 
         Caption         =   "&Quit"
      End
   End
   Begin VB.Menu mnuStep 
      Caption         =   "&Step"
      Begin VB.Menu mnuTempStep 
         Caption         =   "&Temp Step"
      End
   End
   Begin VB.Menu mnuSettings 
      Caption         =   "&Settings"
      Begin VB.Menu mnuGPIBsettings 
         Caption         =   "&GPIB Settings"
      End
      Begin VB.Menu mnuAdvanced 
         Caption         =   "&Advanced Settings"
      End
   End
   Begin VB.Menu menuHelp 
      Caption         =   "&Help"
      Begin VB.Menu mnuAbout 
         Caption         =   "About"
      End
   End
End
Attribute VB_Name = "frmAutotune"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'*******************************************************************
'***                                                             ***
'***             2510/2510-AT Demo                               ***
'***                                                             ***
'*******************************************************************
'
'This program sets all necessary parameters and starts an Autotune session
'for the 2510-AT Autotuning TEC Sourcemeter. It also will allow temperature
'PID control (temperature setpoints) to be performed on a 2510 or
'2510-AT (using frmPIDStep).
'
'It requires a (CEC or NI) GPIB card and an appropriate TEC-equipped DUT
'A demo TEC DUT was manufactured for this purpose and appropriate settings
'are part of the DUTtype = demo feature.  Expert mode allows more control
'over settings (Thermal transducer type; Curr,Volt, temp protection, etc.).
'
'Mad props!! to JCG, who penned the original code for this demo
'and provided the explanatory/informational text

'Required forms
'
'_Name_               _File_                  _Description_
'frmAutotune        AutotuneMain03.frm        Main autotuning form & code
'frmAbout           frmabout.frm              About form
'frmGPIBsettings    frmGPIBsettings.frm       GPIB card type and instrument address settings
'frmPIDStep         frmPIDStep03.frm          PID temperature step form
'frmAdvSettings     frmAdvSettings.frm        Temp Transducer and Setpoint tolerance settings
'frmPIDCoeff        frmPIDCoeff.frm           Permits changing/viewing of AT and custom PID coefficients
'frmTestData        frmTestData.frm           Displays temperature vs time data (for troubleshooting, usually hidden)
'
'Required forms
'
'Declarations       Declarations.bas          Variable declarations
'mod_CEC            Ieeevb.bas                CEC GPIB card driver (from CEC)
'mod_Common         mod_CommonV02.bas         Procedures common to >1 form
'mod_GPIBwrapper    mod_GPIBwrapperv03.bas    "generic" set of procedure to talk to either CEC or NI GPIB drivers
'mod_SettingsFile   mod_SettingsFile.bas      Routines for saving/retrieving GPIB settings to a text file
'NIGLOBAL           niglobal.bas              NI GPIB global variable declarations (from NI)
'VBIB32             vbib-32.bas               NI GPIB driver (from National Instruments)
'
'--------------------------------------------------------------------
'NO WARRANTY
'
'THERE IS NO WARRANTY FOR THE PROGRAM. THE PROGRAM "AS IS" WITHOUT
'WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT
'NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
'FITNESS FOR A PARTICULAR PURPOSE. THE ENTIRE RISK AS TO THE
'QUALITY AND PERFORMANCE OF THE PROGRAM IS WITH YOU. SHOULD THE
'PROGRAM PROVE DEFECTIVE, YOU ASSUME THE COST OF ALL NECESSARY
'SERVICING, REPAIR OR CORRECTION.
'---------------------------------------------------------------------


Option Explicit

Public CurSkip As String
Public GPIBStat As Integer
Public stridn As String
Public OK2510Present As Boolean
Public strExpertInstr                       'Extra instruction step for expert mode
Public strTau As String                     'Tau=thermal response time of system (2510+TEC+DUT)

Private Sub cmdPIDStep_Click()
'Bring up PID form

frmPIDStep.Show

End Sub

Private Sub cmdReadStdRegister_Click()
'Read the Standard Event Register (look for Autotune error)
'Read the Operational Event Register (look for Autotune successful)
'If error, read Error Queue

Call ReadStdRegister                'Read autotune complete status (success or failure)

End Sub

Private Sub Form_Initialize()
'Load default parameter values

Dim temp As Integer
intKI2510 = 10                              'Set default GPIB address


strSetFile = "2510ATDemo.txt"               'Filename for storing demo program settings

frmAdvSettings.optDUTtype(0).value = True   'Set initial default to Demo DUT

cmdPIDStep.Enabled = False                  'Disable PIDStep button

'Also, referring to the TempSettings form will run
'its Form_Initialize code
temp = frmAdvSettings.optLineFreq.count

Call GetSettings                        'Retrieve settings from file

    'Set values for Start temp combo box
    cboStartTemp.List(0) = "10"            '10 C
    cboStartTemp.List(1) = "15"            '15 C
    cboStartTemp.List(2) = "20"            '20 C
    cboStartTemp.List(3) = "25"            '25 C
    cboStartTemp.List(4) = "30"            '30 C
    cboStartTemp.List(5) = "35"            '35 C
    cboStartTemp.List(6) = "40"            '40 C
    cboStartTemp.ListIndex = 2             'set default (displayed) value
    'Set values for Stop temp combo box
    cboStopTemp.List(0) = "20"            '20 C
    cboStopTemp.List(1) = "25"            '25 C
    cboStopTemp.List(2) = "30"            '30 C
    cboStopTemp.List(3) = "35"            '35 C
    cboStopTemp.List(4) = "40"            '40 C
    cboStopTemp.List(5) = "45"            '45 C
    cboStopTemp.List(6) = "50"            '50 C
    cboStopTemp.ListIndex = 1            'Set default value

'Form_Resize

'Add tooltip text to various controls
fraAutoTune.ToolTipText = "These parameters control how the autotuning temperature step is accomplished."
fraSysTau.ToolTipText = "Tau is the thermal response time of the system (TEC+device+2510). Click for more info."
optSysTau(0).ToolTipText = "Use Tau=Short for laser diode modules (Tau <100 seconds)."
optSysTau(1).ToolTipText = "Use Tau=Medium for most test fixtures (100 < Tau < 200 sec)."
optSysTau(2).ToolTipText = "Use Tau=Long for larger test fixtures (Tau > 200 sec)."
fraTuneTempStep.ToolTipText = "Set temp step to use for Autotuning.  Minimum temp difference = 3 C.  Step can be positive or negative."
lblStartTemp.ToolTipText = "Initial temperature for Autotuning step."
cboStartTemp.ToolTipText = "Initial temperature for Autotuning step."
lblStopTemp.ToolTipText = "Final or desired temperature (i.e., desired DUT temperature setpoint)."
cboStopTemp.ToolTipText = "Final or desired temperature (i.e., desired DUT temperature setpoint)."
lblP.ToolTipText = "Proportional gain term, click for more info."
lblI.ToolTipText = "Integral gain term, click for more info."
lblD.ToolTipText = "Derivative gain term, click for more info."

End Sub

Private Sub Form_Resize()
'Redo instruction text box when mode changes between Demo and Expert

End Sub

Private Sub Form_Unload(Cancel As Integer)
'Add Message box to confirm program exit

Cancel = MsgBox("Exit?", 20, "Exit Verify")     'Verify exit

If Cancel = vbYes Then          'Quit application was chosen, close all potentially open forms
    End                         'Stop program execution
End If

End Sub

Private Sub fraSysTau_Click()
'Display System tau information

MsgBox "The tau is the time is takes for the system (2510+TEC+Fixture+DUT) " & vbCrLf & _
        "to change its temperature.  Tau=short is best for the 2510 Demo DUT.  " & vbCrLf & _
        "To change the system Tau, change to " & _
        "Expert mode (under Settings|Advanced Settings).", vbInformation, "Autotune System Tau"

End Sub

Private Sub mnuAbout_Click()
'Display About form when About menu object is chosen

frmAbout.Show

End Sub

Private Sub mnuAdvanced_Click()
'Show form

blnAutotuneMode = True
frmAdvSettings.fraSetpoint.Visible = False     'Hide setpoint stuff, since it doesn't apply to Autotune sessions
frmAdvSettings.Show

End Sub

Private Sub mnuGPIBsettings_Click()
'Bring up GPIB settings form

frmGPIBSettings.txt2510GPIB.Text = intKI2510                     '(re-)set GPIB address
frmGPIBSettings.Show vbModal

End Sub

Private Sub mnuQuit_Click()
'Quit program

Unload frmAutotune

End Sub

Private Sub mnuTempStep_Click()
'Show Temp PID step form

frmPIDStep.Show

End Sub

Private Sub optSysTau_Click(Index As Integer)
'Sends chosen system tau value to 2510
'System Tau Definition:  Amount of time it takes the system (TEC + Fixture or DUT)
'to reach 63% of the final (chosen) temperature setpoint.
'Generally, laser diode modules will have a short tau (tau < 100 seconds, roughly)
'Fixtures will have either medium tau (100 < tau < 200 s, roughly) or
'long tau (tau > 200 s, roughly).

Select Case Index

Case 0          'Tau = Short

    strTau = "SHORT"
    
Case 1          'Tau = Medium
    
    strTau = "MED"

Case 2          'Tau = Long
    
    strTau = "LONG"

End Select

End Sub

Private Sub cmdAutotune_Click()
'Copy below text to program an AT session, in addition you will
'need:  GetAllPID code to retrieve PIDs, cmdSaveSetup to save a single
'       set of PIDs into the 2510
'This procedure configures the 2510-AT and launches the autotune session

Dim ExPhs As String
Dim poll As Integer                                 'stores result of serial poll of instrument
Dim strStdEventReg As String                        'Standard Event Register, stores Autotune ended in error (bit 4, counting from bit 0)
Dim strErrorQueue As String                         'Contains error message
Dim strOperEventReg As String                       'Operational Event Register, stores Autotune successful (bit 7, counting from bit 0)

'Call send(txtAddress.Text, ":SOUR1:TEMP:ATUN:STAR " & cbostarttemp.Text, 1)
'Call send(txtAddress.Text, ":SOUR1:TEMP:ATUN:STOP " & cbostoptemp.Text, 1)
'Call send(txtAddress.Text, ":SENS:CURR:PROT " & txtCurrProt.Text, 1)
'Call send(txtAddress.Text, ":SOUR1:VOLT:PROT " & txtVoltProt.Text, 1)
'Call send(txtAddress.Text, ":SOUR:TEMP:PROT " & txtUppLim.Text, 1)
'Call send(txtAddress.Text, ":SOUR:TEMP:PROT:LOW " & txtLowLim.Text, 1)

''Reset instrument
'If SendKI(intKI2510, "*rst") Then Exit Sub

'Note:  during Autotune session, NO communication is possible with instrument
cmdAutotune.Enabled = False             'Disable button while autotune in session
cmdPIDStep.Enabled = False              'Disable PIDStep button
lblATStatus.Caption = "Autotune in Progress"
ATInstructions (2)                   'Change to Autotune process details in instruction box

'Clear values from PID text boxes
txtMSETKp.Text = ""
txtMSETKi.Text = ""
txtMSETKd.Text = ""
txtMOVKp.Text = ""
txtMOVKi.Text = ""
txtMOVKd.Text = ""

'Disable controls while autotune session in process
fraResults.Enabled = False              'Disable Autotune Results frame

'fraTuneTempStep.Enabled = False         'Disable Autotune temp step frame
lblStartTemp.Enabled = False            'Disable start temp controls
cboStartTemp.Enabled = False            'Disable start temp controls
lblStopTemp.Enabled = False            'Disable stop temp controls
cboStopTemp.Enabled = False            'Disable stop temp controls

'Disable menu options while autotuning (to keep user from sending SCPI commands while autotuning)
mnuStep.Enabled = False
mnuSettings.Enabled = False

'Format returned data: send status register readings in BINary form
If SendKI(intKI2510, "form:sreg bin") Then Exit Sub

'Configure SRQ to flag when autotune is complete (either pass or fail)
If SendKI(intKI2510, "*ese 16") Then Exit Sub                   'Enable Autotune error event (bit 4, counting from 0) in the Measurement Event enable register
If SendKI(intKI2510, "stat:oper:enab 128") Then Exit Sub        'Enable Autotune successful event (bit 7, counting from 0) in the Operational Event Enable register
If SendKI(intKI2510, "*sre 160") Then Exit Sub                  'Enable ESB (bit 5, autotune error, mask = 32) and OSB (bit 7, autotune successful, mask=128) in the Service Request Enable Register, 160=32+128
If SendKI(intKI2510, "*cls") Then Exit Sub                      'clear status registers, must be done to get correct SRQ condition

Call Config2510                                 'Set temp transducer and TEC protection parameters

'Set Autotune temperature step start & stop
If SendKI(intKI2510, ":SOUR1:TEMP:ATUN:STAR " & cboStartTemp.Text) Then Exit Sub
If SendKI(intKI2510, ":SOUR1:TEMP:ATUN:STOP " & cboStopTemp.Text) Then Exit Sub

If SendKI(intKI2510, ":SOUR:TEMP:ATUN:SYSTAU " & strTau) Then Exit Sub

' set tuning method for initial seek to start and stop temps
'use MSET (min settle time) for faster autotune sessions
If SendKI(intKI2510, ":SOUR1:TEMP:ATUN:MSET") Then Exit Sub

' start the autotune process
If SendKI(intKI2510, ":SOUR1:TEMP:ATUN:INIT") Then Exit Sub

Do
    DoEvents                        'Passes control from VB to operating system

Loop Until (SrqKI And 1)            '2510-AT will issue an srq once Autotune is complete (success or failed)
poll = PollKI(intKI2510)            'clear SRQ status byte (& clears SRQ annunciator on front panel)


'Enable & reset various controls since Autotune process is complete
cmdAutotune.Enabled = True          'Enable button when autotune is finished
fraResults.Enabled = True           'Enable Autotune Results frame
fraTuneTempStep.Enabled = True      'ensable Autotune temp step frame
lblATStatus.Caption = ""            'Erase "autotune in progress"
lblStartTemp.Enabled = True            'Disable start temp controls
cboStartTemp.Enabled = True            'Disable start temp controls
lblStopTemp.Enabled = True            'Disable stop temp controls
cboStopTemp.Enabled = True            'Disable stop temp controls
cmdPIDStep.Enabled = True           'Enable PIDStep button

'Disable menu options while autotuning (to keep user from sending SCPI commands while autotuning)
mnuStep.Enabled = True
mnuSettings.Enabled = True


Call ReadStdRegister                'Read autotune complete status (success or failure), then display error or get AT PIDs

End Sub


Private Sub cbostarttemp_LostFocus()
'Ensure that start temp is with temp protection limits

If IsNumeric(cboStartTemp.Text) Then
    If CSng(cboStartTemp.Text) > CSng(frmAdvSettings.txtUppLim.Text) Then
        MsgBox "Enter a temperature below Upper Temp Limit"
        cboStartTemp.Text = frmAdvSettings.txtUppLim.Text
    End If
    If CSng(cboStartTemp.Text) < CSng(frmAdvSettings.txtLowLim.Text) Then
        MsgBox "Enter a temperature above Lower Temp Limit"
        cboStartTemp.Text = frmAdvSettings.txtLowLim.Text
    End If
    Call CheckAutotuneStep
Else
    MsgBox "Enter a temperature between Upper and Lower Temp Limit"
    cboStartTemp.Text = 20#
End If

End Sub

Private Sub cbostoptemp_LostFocus()
'Ensure that stop temp is with temp protection limits

If IsNumeric(cboStopTemp.Text) Then
    If CSng(cboStopTemp.Text) > CSng(frmAdvSettings.txtUppLim.Text) Then
    MsgBox "Enter a temperature below Upper Temp Limit"
    cboStopTemp.Text = frmAdvSettings.txtUppLim.Text
    End If
    If CSng(cboStopTemp.Text) < CSng(frmAdvSettings.txtLowLim.Text) Then
    MsgBox "Enter a temperature above Lower Temp Limit"
    cboStopTemp.Text = frmAdvSettings.txtLowLim.Text
    End If
    Call CheckAutotuneStep
    
Else: MsgBox "Enter a temperature between Upper and Lower Temp Limit"
cboStopTemp.Text = 25
End If
End Sub

Public Sub GetSettings()
'Checks for existance of file=2510ATDemo.txt exists in same directory
'as the 2510 demo program.  If file exists, then loads values from file
'If no file, then display frmGPIBSettings
'Initial file contents only stores GPIB card choice

'If file doesn't exist (in same dir as demo prog), automatically raise frmGPIBSettings to make user
'choose a GPIB card.
blnSetFile = FileExists(strSetFile)
'Troubleshooting code below
'MsgBox "Set file exists= " & blnSetFile & " FileExists= " & FileExists(strSetFile)

If blnSetFile Then 'readfile
    ReadSetting (strSetFile)
    frmGPIBSettings.Show vbModal
    Else: frmGPIBSettings.Show vbModal
End If

frmGPIBSettings.txt2510GPIB = intKI2510         'Copy value to displayed address

End Sub

Public Sub CheckAutotuneStep()
'This ugly procedure ensures that the Autotune temperature step
'is at least 3C, which is required for autotune algorithm to function
'properly.
'Routine just adds or subtracts 3C from either start or stop temp, accounting
'for upper and lower temp limits(assume that upper and lower limits differ by
'about 6C at a minimum)

Const Delta = 3             'Three degree minimum

If Abs(cboStopTemp.Text - cboStartTemp.Text) < Delta Then
    If cboStartTemp.Text > cboStopTemp.Text Then    'Negative temp step
        If cboStartTemp.Text < (frmAdvSettings.txtUppLim.Text - Delta) Then    'Make sure start temp not at Upper temp limit
            cboStartTemp.Text = cboStartTemp.Text + Delta
        ElseIf cboStopTemp.Text > (frmAdvSettings.txtLowLim.Text + Delta) Then    'Make sure stop temp not at lower temp limit
            cboStopTemp.Text = cboStopTemp.Text - Delta
        End If
    Else                                            'Positive temp step (start < stop)
    If cboStartTemp.Text > (frmAdvSettings.txtLowLim.Text + Delta) Then    'Make sure start temp not at lower temp limit
            cboStartTemp.Text = cboStartTemp.Text - Delta
        ElseIf cboStopTemp.Text < (frmAdvSettings.txtUppLim.Text - Delta) Then    'Make sure stop temp not at upper temp limit
                cboStopTemp.Text = cboStopTemp.Text + Delta
        End If
    End If
End If

End Sub

'Public Sub GetAutotunePIDs()
''Get the Minimum Settle Time (MSET) and
''Minimum OVershoot (MOV) PID coefficients
''Display on screen
'
''get MSET Kp
''Call Send(intKI2510, "sour:temp:atun:lcon:mset:gain?", 0)
''Call enter(MSETKp, 20, 0, intKI2510, GPIBStat)
'Call SendKI(intKI2510, "sour:temp:atun:lcon:mset:gain?")
'strMSETKp = QueryKI(intKI2510)
'txtMSETKp.Text = Format(Val(strMSETKp), "####0.0##")
'frmPIDCoeff.txtMSETKd.Text = txtMSETKp.Text      'Copy coeff to PIDStep form
'
''get MSET Ki
''Call Send(intKI2510, "sour:temp:atun:lcon:mset:int?", 0)
''Call enter(MSETKi, 20, 0, intKI2510, GPIBStat)
'Call SendKI(intKI2510, "sour:temp:atun:lcon:mset:int?")
'strMSETKi = QueryKI(intKI2510)
'txtMSETKi.Text = Format(Val(strMSETKi), "####0.0##")
'frmPIDCoeff.txtMSETKi.Text = txtMSETKi.Text      'Copy coeff to PIDStep form
'
''get MSET Kd
''Call Send(intKI2510, "sour:temp:atun:lcon:mset:der?", 0)
''Call enter(MSETKd, 20, 0, intKI2510, GPIBStat)
'Call SendKI(intKI2510, "sour:temp:atun:lcon:mset:der?")
'strMSETKd = QueryKI(intKI2510)
'frmPIDCoeff.txtMSETKd.Text = Format(Val(strMSETKd), "####0.0##")
'
''get MOV (Minimum temp overshoot) values
'
''get MOV Kp
''Call Send(intKI2510, "sour:temp:atun:lcon:mov:gain?", 0)
''Call enter(MOVKp, 20, 0, intKI2510, GPIBStat)
'Call SendKI(intKI2510, "sour:temp:atun:lcon:mov:gain?")
'strMOVKp = QueryKI(intKI2510)
'txtMOVKp.Text = Format(Val(strMOVKp), "####0.0##")
'
''get MOV Ki
''Call Send(intKI2510, "sour:temp:atun:lcon:mov:int?", 0)
''Call enter(MOVKi, 20, 0, intKI2510, GPIBStat)
'Call SendKI(intKI2510, "sour:temp:atun:lcon:mov:int?")
'strMOVKi = QueryKI(intKI2510)
'txtMOVKi.Text = Format(Val(strMOVKi), "####0.0##")
'
''get MOV Kd
''Call Send(intKI2510, "sour:temp:atun:lcon:mov:der?", 0)
''Call enter(MOVKd, 20, 0, intKI2510, GPIBStat)
'Call SendKI(intKI2510, "sour:temp:atun:lcon:mov:der?")
'strMOVKd = QueryKI(intKI2510)
'txtMOVKd.Text = Format(Val(strMOVKd), "####0.0##")
'
'
'End Sub
''Private Sub Get2510ATData()
''Dim textidn As String
''Dim strpresKp As String
''Dim strpresKi As String
''Dim strpresKd As String
''
'''gray out button
'''cmdGet2510Data.Enabled = False
''
''''determine if there - Get *IDN? String
'''textidn = Space$(127)
''''Call Send(ki2510, "*IDN?", 0)
''''Call enter(textidn, 127, 0, ki2510, GPIBStat)
'''Call SendKI(intKI2510, "*IDN?")
'''textidn = QueryKI(intKI2510)
''
''
'''if not a 2510-AT, stop the bus here!
'''If txtModelNum.Text <> "MODEL 2510-AT" Then
'''    OK2510Present = False
'''    cmdUseMSET.Enabled = False
'''    cmdUseMOV.Enabled = False
'''    cmdGoToStartTemp.Enabled = False
'''    cmdStartTakingData.Enabled = False
'''    cmdStopTakingData.Enabled = False
'''    GoTo fino
'''End If
''
'''get present Kp
''Call SendKI(intKI2510, "sour:temp:lcon:gain?")
''strpresKp = QueryKI(intKI2510)
''frmPIDStep.txtKp.Text = Format(Val(strpresKp), "####0.0##")
''
'''get present Ki
''Call SendKI(intKI2510, "sour:temp:lcon:int?")
''strpresKi = QueryKI(intKI2510)
''frmPIDStep.txtKi.Text = Format(Val(strpresKi), "####0.0##")
''
'''get present Kd
''Call SendKI(intKI2510, "sour:temp:lcon:der?")
''strpresKd = QueryKI(intKI2510)
''frmPIDStep.txtKd.Text = Format(Val(strpresKd), "####0.0##")
''
'''get MSET (Minimum settle time) values
''
'''get MSET Kp
''Call SendKI(intKI2510, "sour:temp:atun:lcon:mset:gain?")
''frmPIDStep.strMSETKp = QueryKI(intKI2510)
''frmPIDStep.txtMSETKp.Text = Format(Val(frmPIDStep.strMSETKp), "####0.0##")
''
'''get MSET Ki
''Call SendKI(intKI2510, "sour:temp:atun:lcon:mset:int?")
''frmPIDStep.strMSETKi = QueryKI(intKI2510)
''frmPIDStep.txtMSETKi.Text = Format(Val(frmPIDStep.strMSETKi), "####0.0##")
''
'''get MSET Kd
''Call SendKI(intKI2510, "sour:temp:atun:lcon:mset:der?")
''frmPIDStep.strMSETKd = QueryKI(intKI2510)
''frmPIDStep.txtMSETKd.Text = Format(Val(frmPIDStep.strMSETKd), "####0.0##")
''
'''get MOV (Minimum temp overshoot) values
''
'''get MOV Kp
'''Call Send(intKI2510, "sour:temp:atun:lcon:mov:gain?", 0)
'''Call enter(MOVKp, 20, 0, intKI2510, GPIBStat)
''Call SendKI(intKI2510, "sour:temp:atun:lcon:mov:gain?")
''frmPIDStep.strMOVKp = QueryKI(intKI2510)
''frmPIDStep.txtMOVKp.Text = Format(Val(frmPIDStep.strMOVKp), "####0.0##")
''
'''get MOV Ki
'''Call Send(intKI2510, "sour:temp:atun:lcon:mov:int?", 0)
'''Call enter(MOVKi, 20, 0, intKI2510, GPIBStat)
''Call SendKI(intKI2510, "sour:temp:atun:lcon:mov:int?")
''frmPIDStep.strMOVKi = QueryKI(intKI2510)
''frmPIDStep.txtMOVKi.Text = Format(Val(frmPIDStep.strMOVKi), "####0.0##")
''
'''get MOV Kd
'''Call Send(intKI2510, "sour:temp:atun:lcon:mov:der?", 0)
'''Call enter(MOVKd, 20, 0, intKI2510, GPIBStat)
''Call SendKI(intKI2510, "sour:temp:atun:lcon:mov:der?")
''frmPIDStep.strMOVKd = QueryKI(intKI2510)
''frmPIDStep.txtMOVKd.Text = Format(Val(frmPIDStep.strMOVKd), "####0.0##")
''
'''ungray buttons if valid tuning numbers present
''If Val(frmPIDStep.strMSETKp) <> 0 Then
'''    frmPIDStep.cmdUseMSET.Enabled = True
'''    frmPIDStep.cmdUseMOV.Enabled = True
''    frmPIDStep.cmdGoToStartTemp.Enabled = True
''    frmPIDStep.cmdStartTakingData.Enabled = True
''End If
''
''
''fino:
'''ungray button
'''frmPIDStep.cmdGet2510Data.Enabled = True
''
''End Sub

Public Sub ATInstructions(mode As Integer)
'This procedure changes the instruction box based on the mode:
'0) config Demo mode autotune parameters, 1) config expert mode param
'2) Autotune in process

Select Case mode

Case 0      'Demo mode configure

lblInstructions.Caption = "Instructions"
txtInstructions.Text = "The 2510-AT uses a temperature step to determine the PID coefficients." & vbCrLf & _
                        "1.  Choose desired operating (final) temperature for DUT." & vbCrLf & _
                        "2.  Choose a start temperature." & vbCrLf & _
                        "   a. Cooling - If usually cooling to the desired setpoint, choose a start temp > final temp." & vbCrLf & _
                        "   b. Heating -  If heating to the desired temp, choose a start temp < desired temp." & vbCrLf & _
                        "   c. Magnitude of step:  a start to final temperature difference of 5-20 degrees is usually good." & vbCrLf & _
                        "                                              (the larger the temp step, the longer it will take to tune)" & vbCrLf & _
                        "3.  Press ""Begin Autotune"". "


Case 1      'Expert mode configure

lblInstructions.Caption = "Instructions"
txtInstructions.Text = "The 2510-AT uses a temperature step to determine the PID coefficients." & vbCrLf & _
                        "1.  Choose desired (final) temperature for DUT." & vbCrLf & _
                        "2.  Choose a start temperature." & vbCrLf & _
                        "   a. Cooling - If usually cooling to the desired setpoint, choose a start temp > final temp." & vbCrLf & _
                        "   b. Heating -  If heating to the desired temp, choose a start temp < desired temp." & vbCrLf & _
                        "   c. Magnitude of step:  a start to final temperature difference of 5-20 degrees is usually good." & vbCrLf & _
                        "                                              (the larger the temp step, the longer it will take to tune)" & vbCrLf & _
                        "3.  Set TEC Protection parameters." & vbCrLf & _
                        "4.  Press ""Begin Autotune"". "

Case 2      'Autotune in process

lblInstructions.Caption = "Autotune Process Information"
txtInstructions.Text = "The Autotune process takes roughly: " & vbCrLf & _
                        "                                                       5-20 minutes for a short system tau (Laser Diode Module)" & vbCrLf & _
                        "                                                       20-60 minutes for a medium system tau (fixture)" & vbCrLf & _
                        "                                                       hours for a  long system tau (large fixture)" & vbCrLf & vbCrLf & _
                        "and has 5 steps:   1) Measuring System Temp " & vbCrLf & _
                        "                                   2) Applying Initial Step" & vbCrLf & _
                        "                                   3) Seeking Prog Stop Temp " & vbCrLf & _
                        "                                   4) Seeking Prog Start Temp" & vbCrLf & _
                        "                                   5) Applying Final Step  " & vbCrLf & _
                        "During Autotune, the 2510-AT is dedicated to the algorithm.  Therefore, the front panel and " & vbCrLf & _
                        "communication ports are ignored."

End Select

End Sub
Private Sub lblD_Click()
'Display brief explanation of Derivative term

Call Deriv_Info

End Sub

Private Sub lblI_Click()
'Display brief explanation of Integral term

Call Integral_Info

End Sub

Private Sub lblP_Click()
'Display brief explanation of Proportional term

Call Gain_Info

End Sub

